//
//  GraphicsViewControllerView.m
//  Drawing Rectangles
//
//  Created by Vandad Nahavandipoor on 17/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "GraphicsViewControllerView.h"

@implementation GraphicsViewControllerView

- (id)initWithFrame:(CGRect)frame{
  self = [super initWithFrame:frame];
  if (self) {
    //  Miejsce na kod inicjalizacyjny.
  }
  return self;
}

/* 1 */
//- (void)drawRect:(CGRect)rect{
//  
//  /* Najpierw tworzymy ścieżkę. Pobieramy po prostu uchwyt do ścieżki. */
//  CGMutablePathRef path = CGPathCreateMutable();
//  
//  /* To jest obszar ograniczający prostokąt. */
//  CGRect rectangle = CGRectMake(10.0f,
//                                10.0f,
//                                200.0f,
//                                300.0f);
//  
//  /* Dodanie prostokąta do ścieżki. */
//  CGPathAddRect(path,
//                NULL,
//                rectangle);
//  
//  /* Pobranie uchwytu do bieżącego kontekstu graficznego. */
//  CGContextRef currentContext = UIGraphicsGetCurrentContext();
//  
//  /* Dodanie ścieżki do bieżącego kontekstu graficznego. */
//  CGContextAddPath(currentContext,
//                   path);
//  
//  /* Zdefiniowanie koloru wypełnienia: brązowy. */
//  [[UIColor colorWithRed:0.20f
//                   green:0.60f
//                    blue:0.80f
//                   alpha:1.0f] setFill];
//  
//  /* Zdefiniowanie koloru wypełnienia: brązowy. */
//  [[UIColor brownColor] setStroke];
//  
//  /* Zdefiniowanie wartości 5 jako grubości linii ołówka. */
//  CGContextSetLineWidth(currentContext,
//                        5.0f);
//  
//  /* Narysowanie i wypełnienie ścieżki w kontekście graficznym. */
//  CGContextDrawPath(currentContext,
//                    kCGPathFillStroke);
//  
//  /* Usunięcie ścieżki. */
//  CGPathRelease(path);
//  
//}

/* 2 */
- (void)drawRect:(CGRect)rect{
  
  /* Najpierw tworzymy ścieżkę. Pobieramy po prostu uchwyt do ścieżki. */
  CGMutablePathRef path = CGPathCreateMutable();
  
  /* To obszar ograniczający pierwszy prostokąt. */
  CGRect rectangle1 = CGRectMake(10.0f,
                                 10.0f,
                                 200.0f,
                                 300.0f);
  
  /* To obszar ograniczający drugi prostokąt. */
  CGRect rectangle2 = CGRectMake(40.0f,
                                 100.0f,
                                 90.0f,
                                 300.0f);
  
  /* Umieszczenie obu prostokątów w tablicy. */
  CGRect rectangles[2] = {
    rectangle1, rectangle2
  };
  
  /* Dodanie prostokątów do ścieżki. */
  CGPathAddRects(path,
                 NULL,
                 (const CGRect *)&rectangles,
                 2);
  
  /* Pobranie uchwytu do bieżącego kontekstu graficznego. */
  CGContextRef currentContext = UIGraphicsGetCurrentContext();
  
  /* Dodanie ścieżki do bieżącego kontekstu graficznego. */
  CGContextAddPath(currentContext,
                   path);
  
  /* Zdefiniowanie koloru wypełnienia: niebieski. */
  [[UIColor colorWithRed:0.20f
                   green:0.60f
                    blue:0.80f
                   alpha:1.0f] setFill];
  
  /* Zdefiniowanie koloru ołówka: czarny. */
  [[UIColor blackColor] setStroke];
  
  /* Zdefiniowanie wartości 5 jako grubości linii ołówka. */
  CGContextSetLineWidth(currentContext,
                        5.0f);
  
  /* Narysowanie i wypełnienie ścieżki w kontekście graficznym. */
  CGContextDrawPath(currentContext,
                    kCGPathFillStroke);
  
  /* Usunięcie ścieżki. */
  CGPathRelease(path);
  
}

@end
